//>>>>>>>>>>>>>>>>>>>>>>>>
//ltctwrboard.h
//ltctwrboard.c
//>>>>>>>>>>
//This file contains utilities that are integral to the XTWR-ADCDAC-LTC (TWR-ADCDAC-LTC) board.
//Including a function that changes the decoder GPIO pins to pass the CS line to the appropriate device.
//Note that this function depends on the structure of the LTCTWR_PARAMETER struct.
//If not using that LTCTWR_PARAMETER struct, please rewrite this function and pass in the appropriate file pointers.
//
//Also, it contain functions that will set up the SPI module in such a way to work with the parts on the board.
//And functions that can change SPI parameters as needed.
//



#include <mqx.h>
#include <bsp.h>
#include <spi.h>

#if defined BSP_TWR_K60D100M
#include <spi_dspi.h>  // Kinetis-specific
//#include <spi_spi16.h>  // Kinetis-specific
#else
#include <spi_mcf5xxx_qspi.h>
#endif

#include <ltctwrboard.h>

#include <ltc2600spi.h>
#include <ltc2704spi.h>
#include <ltc2498spi.h>
#include <ltc1859spi.h>

//Code responsible for changing the decoder channel to talk to different CS lines
void set_decoder_channel(uint_8 channel, LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr) 
{
	if(channel & 0x01) 
	{
		//LTCTWR_Params_Ptr->decoderpins[0] |= GPIO_PIN_STATUS_1;
                lwgpio_set_value(&LTCTWR_Params.decoderpins[0], LWGPIO_VALUE_HIGH);
	}
	else 
	{
		//LTCTWR_Params_Ptr->decoderpins[0] &= ~GPIO_PIN_STATUS_1;
          lwgpio_set_value(&LTCTWR_Params.decoderpins[0], LWGPIO_VALUE_LOW);
	}
	
	if(channel & 0x02) 
	{
		//LTCTWR_Params_Ptr->decoderpins[1] |= GPIO_PIN_STATUS_1;
          lwgpio_set_value(&LTCTWR_Params.decoderpins[1], LWGPIO_VALUE_HIGH);
	}
	else 
	{
		//LTCTWR_Params_Ptr->decoderpins[1] &= ~GPIO_PIN_STATUS_1;
          lwgpio_set_value(&LTCTWR_Params.decoderpins[1], LWGPIO_VALUE_LOW);
	}
	
	if(channel & 0x04) 
	{
		//LTCTWR_Params_Ptr->decoderpins[2] |= GPIO_PIN_STATUS_1;
          lwgpio_set_value(&LTCTWR_Params.decoderpins[2], LWGPIO_VALUE_HIGH);
	}
	else 
	{
		//LTCTWR_Params_Ptr->decoderpins[2] &= ~GPIO_PIN_STATUS_1;
          lwgpio_set_value(&LTCTWR_Params.decoderpins[2], LWGPIO_VALUE_LOW);
	}
	
	//ioctl(LTCTWR_Params_Ptr->gpiofd, GPIO_IOCTL_WRITE, &LTCTWR_Params_Ptr->decoderpins );
}



//////////////////////////
// Setup SPI for first use
// Input parameters are found in spi.h
// Just pass the defines and the init struct pointer
//
// The initialization struct declaration is found in spi_MCF5xxx_qspi.h
//////////////////////////

#if defined BSP_TWR_K60D100M
uint_32 setup_SPI (uint_32 cspin, uint_32 baudrate, uint_32 clockmode, uint_32 transfermode, uint_32 sysclock, DSPI_INIT_STRUCT_PTR init)
#else
uint_32 setup_SPI (uint_32 cspin, uint_32 baudrate, uint_32 clockmode, uint_32 transfermode, uint_32 sysclock, MCF5XXX_QSPI_INIT_STRUCT_PTR init)
#endif
{
#if defined BSP_TWR_K60D100M
  // Memory pointer variable not used on Kinetis
#else
  VMCF5225_STRUCT_PTR reg_ptr;  //Memory pointer for MCF5225 to configure the GPIO secondary function register
#endif  

#if defined BSP_TWR_K60D100M
//DSPI_INIT_STRUCT _bsp_dspi2_init =
//   {
//   	2, //Channel
//   	0, //CS
//   	0, //Transfer Mode
//   	0, //Baud Rate
//   	BSP_BUS_CLOCK, //Clock speed BSP_SYSTEM_CLOCK
//   	0, //Clock Polarity Phase
//   	1, //RX Buffer
//   	1 //TX Buffer
//   	
//   };  //Struct for SPI initialization needs to be a constant
//DSPI_INIT_STRUCT _bsp_dspi2_init = 
//   {
//   	2, //Channel
//   	CM_CLOCK_SOURCE_BUS /* Relevant module clock source */	
//   };  //Struct for SPI initialization needs to be a constant

//const SPI_INIT_STRUCT _bsp_spi2_init = {
//&_spi_dspi_devif, /* Low level driver interface */
//&_bsp_dspi2_init, /* Low level driver init data */
//{ /* Default parameters: */
//0, /* Baudrate */
//SPI_CLK_POL_PHA_MODE0, /* Mode */
//8, /* Frame size */
//1, /* Chip select */
//DSPI_ATTR_USE_ISR, /* Attributes */
//0xFFFFFFFF /* Dummy pattern */
//}
//};
#else
MCF5XXX_QSPI_INIT_STRUCT _bsp_qspi0_init = 
   {
   	0, //Channel
   	0, //CS
   	0, //Transfer Mode
   	0, //Baud Rate
   	BSP_BUS_CLOCK, //Clock speed BSP_SYSTEM_CLOCK
   	0, //Clock Polarity Phase
   	1, //RX Buffer
   	1 //TX Buffer   	
   };  //Struct for QSPI initialization needs to be a constant
#endif

   //Prepare the initialization struct   
#if defined BSP_TWR_K60D100M
   init->CHANNEL = 2;
#else
   init->CHANNEL = 0;   
#endif
 //  init->CS = cspin;
 //  init->TRANSFER_MODE = transfermode;
//   init->BAUD_RATE = baudrate;
 // init->CLOCK_SPEED = sysclock;
//   init->CLOCK_POL_PHASE = clockmode;
 //  init->RX_BUFFER_SIZE = 1;
//   init->TX_BUFFER_SIZE = 1;
   

   //Set the pins to their secondary function
#if defined BSP_TWR_K60D100M
  /* clock gate */
  SIM_SCGC6 |= SIM_SCGC6_SPI0_MASK|SIM_SCGC6_SPI1_MASK;
  SIM_SCGC3 |= SIM_SCGC3_SPI2_MASK;
  SIM_SCGC5 |= SIM_SCGC5_PORTD_MASK | SIM_SCGC5_PORTB_MASK;
  /* pin mux */
  PORTD_PCR11 &= ~PORT_PCR_MUX_MASK;
  PORTD_PCR11 |= PORT_PCR_MUX(2); //SPI2_PCS0
  PORTD_PCR12 &= ~PORT_PCR_MUX_MASK;
  PORTD_PCR12 |= PORT_PCR_MUX(2); //SPI2_SCK
  PORTD_PCR13 &= ~PORT_PCR_MUX_MASK;
  PORTD_PCR13 |= PORT_PCR_MUX(2); //SPI2_SOUT
  PORTD_PCR14 &= ~PORT_PCR_MUX_MASK;
  PORTD_PCR14 |= PORT_PCR_MUX(2); //SPI2_SIN   
  
#else
   reg_ptr = _PSP_GET_IPSBAR();
   reg_ptr->GPIO.PQSPAR &= (~ (MCF5225_GPIO_PQSPAR_PQSPA0(3) | MCF5225_GPIO_PQSPAR_PQSPA1(3) | MCF5225_GPIO_PQSPAR_PQSPA2(3) | MCF5225_GPIO_PQSPAR_PQSPA3(3)));
   reg_ptr->GPIO.PQSPAR |= (MCF5225_GPIO_PQSPAR_PQSPA0(1) | MCF5225_GPIO_PQSPAR_PQSPA1(1) | MCF5225_GPIO_PQSPAR_PQSPA2(1) | MCF5225_GPIO_PQSPAR_PQSPA3(1));
#endif   
   
//   The fopen call doesn't install the driver with our initialization
//   _mcf5xxx_qspi_polled_install("spi0:", init);

#if defined BSP_TWR_K60D100M
//   _dspi_int_install("ispi2:", init); //Modified-for-Kinetis
#else
     _mcf5xxx_qspi_int_install("ispi0:", init);
#endif
}


//////////////////////////
// Update SPI
// Input parameters are found in spi.h
// Just pass the defines
//////////////////////////

uint_32   update_SPI (uint_32 cspin, uint_32 baudrate, uint_32 clockmode, uint_32 endian, uint_32 transfermode,  FILE_PTR spifd)
{
   uint_32 param, output = SPI_OK;

   /*Changing CS pin mask*/
   param = cspin;
   //printf ("Changing CS pin mask to %d  ... ", param);
   output = output | ioctl (spifd, IO_IOCTL_SPI_SET_CS, &param);


   /* Set a different rate */
   param = baudrate;
   //printf ("Changing the baud rate to %d Hz ... ", param);
   output = output | ioctl (spifd, IO_IOCTL_SPI_SET_BAUD, &param);


   /* Set clock mode */
   param = clockmode;  //Inactive SPICLK low & sample rising
   //printf ("Setting clock mode to %d ... ", param);
   output = output | ioctl (spifd, IO_IOCTL_SPI_SET_MODE, &param);

   
   /* Set big endian - LTC devices uses this*/
   param = endian;
   //printf ("Setting endian to %d ... ", param);
   output = output | ioctl (spifd, IO_IOCTL_SPI_SET_ENDIAN, &param);


   /* Set transfer mode */
   param = transfermode;
   //printf ("Setting transfer mode to %d ... ", param);
   output = output | ioctl (spifd, IO_IOCTL_SPI_SET_TRANSFER_MODE, &param);


	return output;
}

//Change the baud rate of the SPI module
uint_32   change_SPI_baud(uint_32 param, FILE_PTR spifd)
{
	return ioctl (spifd, IO_IOCTL_SPI_SET_BAUD, &param);
}

//Change the chip-select pin
uint_32   change_SPI_CS(uint_32 param, FILE_PTR spifd)
{
	return ioctl (spifd, IO_IOCTL_SPI_SET_CS, &param);	
}

//Allows you to change the endian-ness
uint_32   change_SPI_endian(uint_32 param, FILE_PTR spifd)
{
	return ioctl (spifd, IO_IOCTL_SPI_SET_ENDIAN, &param);	
}

//Allows you to change clock phase and polarity
uint_32   change_SPI_clockmode(uint_32 param, FILE_PTR spifd)
{
	return ioctl (spifd, IO_IOCTL_SPI_SET_MODE, &param);	
}


